/**
 *  A set of expenses is submitted having the form:
 *
 *    name    amount    reason
 */

def totalExpenses(expenseLines) {
    def total = 0
    expenseLines.each { expenseLine ->
        def expense = expenseLine.tokenize()
        total += expense[1].toDouble()
    }
    return total
}

def expensesData = ['John   45.00    Train',
                    'Ken   102.20    Air',
                    'Sally  22.20    Supplies']

println "Total expenses: ${totalExpenses(expensesData)}"
