import groovy.util.*
import java.util.regex.*

class GroovyIteratorTests extends GroovyTestCase {

    void setUp() {
        numbers = [11, 12, 13, 14]
        staffTelephones = ['Ken' : 2745, 'John' : 2746, 'Sally' : 2742]
        century = 2000..2099
    }
    
    	// method any
    void testAny() {
        assertTrue('One even value', numbers.any {element -> return (element % 2 == 0) })
        assertTrue('Ken is staff member', staffTelephones.any {entry -> return (entry.key == 'Ken')})
        assertTrue('This century all correct', century.any { element -> return (element >= 2000 && element < 2100)})
    }
    
    void testCollect() {
        assertTrue('Doubled numbers', [22, 24, 26, 28] == numbers.collect {element -> return 2 * element})
        assertTrue('Incremented telephone number', [2746, 2747, 2743].containsAll(staffTelephones.collect {entry -> return ++entry.value}))
        assertTrue('Next century', (2100..2199).containsAll(century.collect {element -> return 100 + element}))
    }
    
    void testEach() {
        def numbersResult = ""
        numbers.each {element -> numbersResult = numbersResult + "+" + element}
        assertTrue('Numbers +', Pattern.compile('(\\+[0-9][0-9])*').matcher(numbersResult).find())
        
        def staffTelephonesResult = ""
        staffTelephones.each {entry -> staffTelephonesResult = staffTelephonesResult + "+" + entry.key}
        assertTrue('Names +', Pattern.compile('(\\+[A-Z][a-z]*)*').matcher(staffTelephonesResult).find())
        
        def centuryResult = ""
        century.each {element -> centuryResult = centuryResult + "+" + element}
        assertTrue('Numbers +', Pattern.compile('(\\+[0-9][0-9])*').matcher(centuryResult).find())
    }
    
    void testEvery() {
        assertTrue('Every number 11..14', numbers.every {element -> return (element >= 11 && element <= 14)})
        assertTrue('', staffTelephones.every {entry -> return [2745, 2746, 2742].contains(entry.value)})
        assertTrue('This century', century.every {element -> return (element >= 2000 && element < 2100)})
    }
    
    void testFind() {
        assertTrue('First is 11', 11 == numbers.find {element -> return element > 10})
        assertTrue('Ken at 2745', 2745 == (staffTelephones.find {entry -> return (entry.key == 'Ken')}).value)
        assertTrue('Last year', 2099 == century.find {element -> return (element == 2099)})
    }
    
    void testFindAll() {
        assertTrue('Last two', [13, 14].containsAll(numbers.findAll {element -> return (element > 12)}))
        assertTrue('Ken at 2745', 1 == (staffTelephones.findAll {entry -> return (entry.key == 'Ken')}).size())
        assertTrue('', 50 == (century.findAll {element -> return (element >= 2050)}).size())
    }
    
    void testFinIndexOf() {
        assertTrue('Position of 13', 2 == numbers.findIndexOf {element -> return (element > 12)})
        assertTrue('Map indexing', staffTelephones.size() > staffTelephones.findIndexOf {entry -> return (entry.key == 'Ken')})
        assertTrue('', 99 == century.findIndexOf {element -> return (element == 2099)})
    }
    
    void testInject() {
        assertTrue('Adding numbers', 50 == numbers.inject(0) {previous, element -> return previous + element})
        assertTrue('All in century', century.inject(true) {previous, element -> return (previous && (2000 <= element && element <= 2099))})
    }
    
    void testReverseEach() {
        def numbersResult = ""
        numbers.reverseEach {element -> numbersResult = numbersResult + "+" + element}
        assertTrue('Numbers +', Pattern.compile('(\\+[0-9][0-9])*').matcher(numbersResult).find())
        
        def centuryResult = ""
        century.reverseEach {element -> centuryResult = centuryResult + "+" + element}
        assertTrue('Numbers +', Pattern.compile('(\\+[0-9][0-9])*').matcher(centuryResult).find())
    }

// ---------- properties ----------------------------------

    def numbers
    def staffTelephones
    def century
}
