/**
 *  Bubblesort as a closure. Scope rules would not permit
 *    the first parameter of closure swap to be named as list.
 */

def bubbleSort = { list ->

    def swap = {values, j, k ->
        def temp = values[j]
        values[j] = values[k]
        values[k] = temp
    }
    
    def size = list.size()
    def numberSorted = 0
    
    while(numberSorted < size) {
        for(index in 1..<(size - numberSorted)) {
            if(list[index] < list[index - 1])
                swap(list, index, index - 1)
        }
        numberSorted++
    }
    
    return list
}

def numbers = [13, 14, 11, 12, 14]
println "Sorted numbers: ${bubbleSort(numbers)}"
