/**
 *  A bank account represented by two properties for the account
 *    number and the account balance. Protected properties also
 *    introduce getters and setters that are themselves protected.
 */

class Account {
    
    def credit(amount) {
        balance += amount
    }
    
    def debit(amount) {		// only if there are sufficient funds
        if(balance >= amount)
            balance -= amount
    }
    
    def display() {
        println "Account number: ${number} balance: ${balance}"
    }
    
// ---------- properties ----------------------------------

    protected number			// account number
    protected balance			// current balance
}

	//  Create an instance
	//  Since the setters are protected then the object instance
	//    is not correctly initialized
def acc = new Account(number : 'ABC123', balance : 1200)
acc.display()

	//  Change things with the automatic setters
//acc.number = 'DEF456'			// ERROR: Cannot access protected member
//acc.balance = 1500			// ERROR: Cannot access protected member
