/**
 *  The example shows how to navigate through related objects to obtain
 *    the desired effect.
 */

class Account {
    
    def credit(amount) {
        balance += amount
    }
    
    def debit(amount) {		// only if there are sufficient funds
        if(balance >= amount)
            balance -= amount
    }
    
    String toString() {
        return "Account: ${number} ${balance}"
    }
    
// ---------- properties ----------------------------------

    def number			// account number
    def balance			// current balance
}

class Customer {
    
    def openAccount(number, balance) {
        def acc = new Account(number : number, balance : balance)
        accounts[number] = acc
    }
    
    String toString() {
        return "Customer: ${number} ${name}"
    }
    
// ---------- properties ----------------------------------

    def number			// account number
    def name			// current balance
    def accounts = [ : ]
}

class Bank {
    
    def registerCustomer(cust) {
        customers[cust.number] = cust
    }
    
    String toString() {
        return "Bank: ${name}"
    }
    
// ---------- properties ----------------------------------

    def name			// current balance
    def customers = [ : ]
}

def displayAllAccounts(bank) {
    println "Bank: ${bank.name} (all accounts)"
    println '============================'
    
    bank?.customers.each { customerNumber, customer ->
        println customer
        customer?.accounts.each { accountNumber, account -> println "  ${account}" }
    }
    println()
}

def displayAllAccountsForCustomer(bank, customerNumber) {
    println "Bank: ${bank.name} (customer accounts)"
    println '================================='
        
    def customer = bank?.customers[customerNumber]
    println customer
    customer?.accounts.each { number, account -> println "  ${account}" }
    println()
}

def displayAccountForCustomer(bank, customerNumber, accountNumber) {
    println "Bank: ${bank.name} (customer account)"
    println '================================='
       
    def customer = bank?.customers[customerNumber]
    def account = customer?.accounts[accountNumber]
    println "  ${account}"
    println()
}



	//  create a Bank...
def bk = new Bank(name : 'Barclay')

	//  ...and some customers with accounts
def cust1 = new Customer(number : 111, name : 'Savage')
cust1.openAccount(1111, 1200)
cust1.openAccount(1112, 400)
cust1.openAccount(1113, 800)

def cust2 = new Customer(number : 222, name : 'Kennedy')
cust2.openAccount(2221, 1000)
cust2.openAccount(2222, 1400)

	//  now register customers with bank
bk.registerCustomer(cust1)
bk.registerCustomer(cust2)



	//  print some reports
displayAllAccounts(bk)
displayAllAccountsForCustomer(bk, 111)
displayAccountForCustomer(bk, 222, 2222)
