/**
 *  A simple closure that multiplies two numeric values.
 *    The multiply closure accepts a single parameter and
 *    multiplies it by the value of the multiplier from the
 *    enclosing scope.
 */

def multiplier = 2
def multiply = { x -> return x * multiplier }	// second operand from enclosing scope

println "multiply(3): ${multiply.call(3)}"
println "multiply(5.6): ${multiply(5.6)}"


	//  Now do it again but with a different multiplier value
multiplier = 3

println "multiply(3): ${multiply.call(3)}"
println "multiply(5.6): ${multiply(5.6)}"
