/**
 *  The arithmetic closure is a simple demonstration of
 *    a closure returning a closure as its result.
 */

	//  Various closures
def add = { x, y -> return x + y }
def subtract = { x, y -> return x - y }
def multiply = { x, y -> return x * y }
def divide = { x, y -> return x / y }

	//  Select a closure
def arithmetic = { arith ->
    switch(arith) {
        case 'ADD':		return add
        case 'SUBTRACT':	return subtract
        case 'MULTIPLY':	return multiply
        case 'DIVIDE':		return divide
        default:		return add
    }
}

	//  Get one...
def addOperation = arithmetic('ADD')
def mulOperation = arithmetic('MULTIPLY')

	//  ...and use it
println "addOperation(3, 4): ${addOperation(3, 4)}"
println "mulOperation(3, 4): ${mulOperation(3, 4)}"

	//  Get one and use it
println "arithmetic('MULTIPLY')(3, 4): ${arithmetic.call('MULTIPLY').call(3, 4)}"
