/**
 *  The multiply closure represents a partial application of
 *    binary multiplication. Its single parameter (x) is used
 *    to deliver a closure that multiplies its own parameter
 *    by the given value for x.
 */

def multiply = { x, y -> return x * y }

	//  Now some partial applications...
	//  ...both are closures
def triple = multiply.curry(3)
def quadruple = multiply.curry(4)

	//  Both are partial applications of multiply
println "triple(4): ${triple(4)}"
println "quadruple(5): ${quadruple(5)}"
