/**
 *  Handling left and right commutativity.
 */

def rSubtract = { y, x -> return x - y }
def lSubtract = { x, y -> return x - y }

def subtract10 = rSubtract.curry(10)
def subtractFrom20 = lSubtract.curry(20)

println "subtract10(22): ${subtract10(22)}"
println "subtractFrom20(14): ${subtractFrom20(14)}"
