/**
 *  Composition of two closures. Given two closures f and g,
 *    first apply the closure g to the given argument then the
 *    closure f to the result produced.
 */

	//  Composition closure
def composition = { f, g, x -> return f(g(x)) }

	//  Multiply closure and two instances
def multiply = { x, y -> return x * y }

def triple = multiply.curry(3)
def quadruple = multiply.curry(4)


	//  Construct a new closure by combining two others
def twelveTimes = composition.curry(triple, quadruple)

println "twelveTimes(12): ${twelveTimes(12)}"
