/**
 *  Applying to all -- mapping. A mapping is used to transform all
 *    the elements of a list.
 */

	//  map closure
def map = { clos, list -> return list.collect(clos) }

	//  composition closure
def composition = { f, g, x -> return f(g(x)) }

	//  Multiply closure and two instances
def multiply = { x, y -> return x * y }

def triple = multiply.curry(3)
def quadruple = multiply.curry(4)

	//  closure to triple the elements in a list
def tripleAll = map.curry(triple)

def table = tripleAll([1, 2, 3, 4])

println "table: ${table}"
