/**
 *  Binary composition.
 */

	// Book class and instance
class Book {

    def name	// properties
    def author
    def price
    def category
}

def bk = new Book(name : 'Groovy', author : 'KenB', price : 35, category : 'CompSci')

	// constants
def discountRate = 0.1
def taxRate = 0.17
def maxDiscount = 3

	//  basic closures
def rMultiply = { y, x -> return x * y }
def lMultiply = { x, y -> return x * y }

def subtract = { x, y -> return x - y }
def rSubtract = { y, x -> return x - y }
def lSubtract = { x, y -> return x - y }

	//  minimum closure
def min = { x, y -> return (x < y) ? x : y }

	// identity closure
def id = { x -> return x }

	//  composition closures
def composition = { f, g, x -> return f(g(x)) }

	// binary composition
def bComposition = { h, f, g, x -> return h(f(x), g(x)) }

	//  book closures
def calcDiscount = rMultiply.curry(discountRate)

def calcActualDiscount = bComposition.curry(min, calcDiscount, id)

def calcDiscountedPrice = bComposition.curry(subtract, id, calcActualDiscount)

def calcTax = rMultiply.curry(1 + taxRate)

def calcNetPrice = composition.curry(calcTax, calcDiscountedPrice)

	//  now calculate net price
println "bk.price: ${bk.price}"

def netPrice = calcNetPrice(bk.price)
println "netPrice: ${netPrice}"
