import fp.*

/**
 *  By using currying, map and filter closures operate together
 *    on lists of lists. Here, we are able to find words of length
 *    3 in a list of sentences (represented by a list of words).
 */

def isSize3 = { text -> return (text.length() == 3) }

def rhyme = [['Fee', 'Fie', 'Fo', 'Fum'],
             ['I', 'smell', 'the', 'blood', 'of', 'an', 'Englishman']
            ]

println "map(filter(isSize3), rhyme): ${Functor.map.call(Functor.filter.curry(isSize3), rhyme)}"
