/**
 *  A specialized builder which produces SQL text to create
 *    a database and its tables.
 */

import groovy.util.*
import java.io.*

class SqlBuilder extends BuilderSupport {

    protected void setParent(Object parent, Object child) {
    }
    
    protected Object createNode(Object name) {
        println "createNode(${name})"
        return name
    }

    protected Object createNode(Object name, Object value) {
        println "createNode(${name}, ${value})"
        return name
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        this.processStartNode(name, attributes, value)
        return name
    }

    protected Object createNode(Object name, Map attributes) {
        return createNode(name, attributes, null)
    }
    
    protected void nodeCompleted(Object parent, Object node) {
        this.processEndNode(parent, node)
    }
    
    private void processStartNode(Object name, Map attributes, Object value) {
        switch(name) {
            case 'database' :
                out.println "DROP DATABASE IF EXISTS ${attributes.get('name')};"
                out.println "CREATE DATABASE ${attributes.get('name')};"
                break
            case 'table' :
                out.println "DROP TABLE IF EXISTS ${attributes.get('name')};"
                out.println "CREATE TABLE ${attributes.get('name')}("
                out.print "  ${attributes.get('name')}_ID INTEGER NOT NULL"
                break
            case 'field' :
                out.println ","
                out.print "  ${attributes.get('name')} ${typeToSQL[attributes.get('type')]}"
                break
        }
    }
    
    private void processEndNode(Object parent, Object node) {
        switch(node) {
            case 'table' :
                out.println()
                out.println ');'
                break
        }
    }

// ---------- properties ----------------------------------

    @Property out
    @Property typeToSQL = ['text' :	'TEXT NOT NULL',
                           'id' :	'INTEGER NOT NULL',
                           'integer' :	'INTEGER NOT NULL']
}

def sB = new SqlBuilder(out : new File('db.sql').newPrintWriter())

def sql = sB.database(name : 'library') {
    table(name : 'Book') {
        field(name : 'title', type : 'text')
        field(name : 'isbn', type : 'text')
        field(name : 'price', type : 'integer')
        field(name : 'author', type : 'id')
        field(name : 'publisher', type : 'id')
    }
}

sB.out.flush()
sB.out.close()
