/**
* Some representative unit tests of the Groovy math model.
* They are (mostly) based on assertions made on the Groovy home web site,
* http://groovy.codehaus.org.
*/
import groovy.util.GroovyTestCase

class GroovyMathTest extends GroovyTestCase {

// Most examples were taken from http://groovy.codehaus.org

    void testExactLiteralDefaultCalculations(){
        assertTrue( 1.1 + 0.1 == 1.2 )
    }
    
    void testOctal() {
        assertTrue( 0177 == 127 )
    }
    
    void testHexadecimal() {
        assertTrue( 0xAB == 171 )
    }
    
    void testSuffixes() {
        assertTrue( "I suffix", 42I == new Integer("42") )
        assertTrue( "L suffix", 123L == new Long("123") )
        assertTrue( "Long type", 2147483648 == new Long("2147483648") ) 
        assertTrue( "G suffix #1", 456G == new java.math.BigInteger("456") ) 
        assertTrue( "G suffix #2", 123.45G == new java.math.BigDecimal("123.45") )
        assertTrue( "G suffix #3", 123.45G == new Double("123.45") )
        assertTrue( "Default BigDecimal type", 123.45 == new java.math.BigDecimal("123.45") )
        assertTrue( "D suffix", 1.200065D == new Double("1.200065") )
        assertTrue( "F suffix", 1.234F == new Float("1.234") )
        assertTrue( "E suffix", 1.23E23D == new Double("1.23E23") )
        assertTrue( "e suffix", 1.23e23D == new Double("1.23e23") )
    }
    
    void testDivision() {
        assertTrue( "Trailing zeros removed", 1/2 == new java.math.BigDecimal("0.5") )
        assertTrue( "Normalized to 10 places #1", 1/3 == new java.math.BigDecimal("0.3333333333") )
        assertTrue( "Normalized to 10 places #2", 2/3 == new java.math.BigDecimal("0.6666666667") )
    }
    
    void testIntegerDivisionByCasting(){
         assertTrue( (int)(3/2) == 1I )
    }
    
    void testIntegerDivisionByIntdiv(){
         assertTrue( 3.intdiv(2) == 1I )
    }
    
    void testBinaryOperationConvertionMatrix() {
        // Many more assertions could be made.
        //
        assertTrue( "#1 G + G #1", (123.45 + 67.8).getClass().getName()== "java.math.BigDecimal" )
        assertTrue( "#1 G + G #2", (123.45 + 67G).getClass().getName()== "java.math.BigDecimal" )
        assertTrue( "#1 G + D", (123.45 + 67.8D).getClass().getName()== "java.lang.Double" )
        assertTrue( "#1 G + F", (123.45 + 67.8F).getClass().getName()== "java.lang.Double" )
        assertTrue( "#1 G + L", (123.45 + 67L).getClass().getName()== "java.math.BigDecimal" )
        assertTrue( "#1 G + I", (123.45 + 67I).getClass().getName()== "java.math.BigDecimal" )
        //
        assertTrue( "#2 G + G #1", (123 + 67.8).getClass().getName()== "java.math.BigDecimal" )
        assertTrue( "#2 G + G #2", (123 + 67G).getClass().getName()== "java.math.BigInteger" )
        assertTrue( "#2 G + D", (123 + 67.8D).getClass().getName()== "java.lang.Double" )
        assertTrue( "#2 G + F", (123 + 67.8F).getClass().getName()== "java.lang.Double" )
        assertTrue( "#2 G + L", (123G + 67L).getClass().getName()== "java.math.BigInteger" )
        assertTrue( "#2 G + I", (123G + 67I).getClass().getName()== "java.math.BigInteger" )
        //
        assertTrue( "#3 L + L", (123 + 67L).getClass().getName()== "java.lang.Long" )
        assertTrue( "#3 I + I", (123 + 67I).getClass().getName()== "java.lang.Integer" )      
    }
}
