/**
 *  A method with a closure as its last parameter can permit the
 *    actual closure parameter to be omitted from the actual
 *    parameter list and to appear immediately following the
 *    closing parenthesis. When the closure is the only parameter
 *    then we omit the parentheses altogether.
 */

def greeting = 'Hello'
def clos = { param -> println "${greeting} ${param}" }

def demo(clo) {
    def greeting = 'Bonjour'	// does not affect closure
    clo.call('Ken')
}

//demo() clos					// 1: closure reference; include parentheses
demo() { param -> println "Welcome ${param}" }	// 2: closure literal; include parentheses

demo clos					// 3: closure reference; omit parentheses
demo { param -> println "Welcome ${param}" }	// 4: closure literal; omit parentheses
