/**
 *  Groovy enhances the standard classes such as File with additional
 *    methods that accept closures as parameters. Method eachLine
 *    accepts a closure and iterates over each line of the file.
 */

import java.io.File

if(args.size() != 1)
    println 'Usage: example02 filename'
else {
	//  Print each line of the file
    new File(args[0]).eachLine { line ->
        println "Line: ${line}"
    }
}
