/**
 *  Groovy enhances the standard classes such as File with additional
 *    methods that accept closures as parameters. Method eachFileRecurse
 *    is applied to a directory, accepts a closure and iterates over each
 *    file in the directory and recursively through sub-directories.
 */

import java.io.File

	//  List those files exceeding a given size
def printDir(dirName, size) {
    new File(dirName).eachFileRecurse { file ->
        if(file.length() > size)
            println "${file.getName()}"
    }
}

if(args.size() != 2 || new File(args[0]).isDirectory() == false)
    println 'Usage: example05 directory'
else {
	//  List from the current directory
    printDir(args[0], args[1].toInteger())
}
