/**
 *  Groovy enhances the standard classes such as File with additional
 *    methods that accept closures as parameters. Method eachLine
 *    accepts a closure and iterates over each line of the file.
 *
 *  A simple demonstration of file copying.
 */

import java.io.*

if(args.size() != 2)
    println 'Usage: example06 filename filename'
else {
	//  Write to a destination file
    def outFile = new File(args[1])
    if(outFile.exists())
        outFile.delete()

	//  Create a PrintWriter
    def printWriter = outFile.newPrintWriter()

	//  Copy each line of the file
    new File(args[0]).eachLine { line ->
        printWriter.println(line)
    }

	//  Close up
    printWriter.flush()
    printWriter.close()
}

