/**
 *  Groovy enhances the standard classes such as File with additional
 *    helper methods that create input output objects.
 *
 *  A simple demonstration of file sorting.
 *
 *  Usage: groovy example08.groovy filename
 */

import java.io.*

if(args.size() != 1)
    println 'Usage: example08 filename'
else {
    def lines = []
    
    	//  Read from the text file
    new File(args[0]).eachLine { line ->
        lines << line
    }
    
    	//  Sort the text
    lines.sort()
    
    	//  Write back to text file
    new File(args[0]).withPrintWriter { printWriter ->
        lines.each { line ->
            printWriter.println(line)
        }
    }
}
