/**
 *  exercise04
 *
 */

import console.*

def addBook(library, bookTitle) {
    library[bookTitle]= []
}

def removeBook(library, bookTitle) {  
    library.remove(bookTitle)      
}

def lendBook(library, bookTitle, borrowerName) {
    library[bookTitle] << borrowerName       
}

def returnBook(library, bookTitle, borrowerName) {
    library[bookTitle].remove(borrowerName)
}

def writeLoanStock(library) {
    println "\nLibrary stock: ${library} \n"
}

def readNumberBorrowedBooks(library, borrowerName) {
    def borrowerNames = library.values().asList()
    borrowerNames = borrowerNames.flatten()
    return borrowerNames.count(borrowerName)
}

def readAllBooks(library) {
    return library.keySet()
}

def readNumberBorrowers(library, bookTitle) {
    return library[bookTitle].size()
}

def readBorrowers(library, bookTitle) {
    return library[bookTitle]
}

def readAllBorrowers(library) {
    def borrowerNames = library.values().asList()
    borrowerNames = borrowerNames.flatten()
    borrowerNames = new HashSet(borrowerNames)
    return borrowerNames
}

def readBookTitle(){
    print('\tEnter book title: ')
    return Console.readLine()
}

def readBorrowerName(){
    print('\tEnter borrower name: ')
    return Console.readLine()
}

def readMenuSelection(){
    print('''
    0: Quit
    1: Add new book
    2: Remove book
    3: Lend a book
    4: Return a book
    5: Display loan stock
    6: Display number of books on loan to a borrower
    7: Display number of borrowers of a book
    8: Display borrowers of a book
    9: Display all borrowers
   10: Display all books
       
        Enter choice: ''')      
    return Console.readString()
} 


def library = ['Groovy' : ['Ken', 'John'],
               'OOD' : ['Ken'],
               'Java' : ['John', 'Sally'],
               'UML' : ['Sally'],
               'Basic' : []
              ]
    
def choice = readMenuSelection()

while(choice != '0'){
    
    if(choice == '1'){      
        addBook(library, readBookTitle())
    }
    else if(choice == '2'){
        removeBook(library, readBookTitle())   
    }
    else if(choice == '3'){
        lendBook(library, readBookTitle(), readBorrowerName())
    }
    else if(choice == '4'){
        returnBook(library, readBookTitle(), readBorrowerName())
    }
    else if(choice == '5'){
        writeLoanStock(library)
    }
    else if(choice == '6'){
        def count = readNumberBorrowedBooks(library, readBorrowerName())
        println "\nNumber of books borrowed: ${count}\n"
    }
    else if(choice == '7'){
        def count = readNumberBorrowers(library, readBookTitle())
        println "\nNumber of borrowers: ${count}\n"
    }
    else if(choice == '8'){
        def borrowerNames = readBorrowers(library, readBookTitle())
        println "\nBorrowers: ${borrowerNames.sort()}\n"
        
    }
    else if(choice == '9'){
        def borrowerNames = readAllBorrowers(library)
        println "\nBorrowers: ${borrowerNames.sort()}\n" 
    }
    else if(choice == '10'){
        def bookTitles = readAllBooks(library)
        println "\nBooks: ${bookTitles.sort()}\n" 
    }
    else {
        println('\nUnknown selection\n')
    }
      // next selection
    choice = readMenuSelection()
}
println('\nSystem closing\n')