/**
 *  exercise05
 *
 *  advantages: local closure is hidden, code is closer to point of use.
 *
 */

import console.*

def readBookTitle(){
    print('\tEnter book title: ')
    return Console.readLine()
}

def readBorrowerName(){
    print('\tEnter borrower name: ')
    return Console.readLine()
}

def readMenuSelection(){
    println()
    println('0: Quit')
    println('1: Add new book')
    println('2: Remove book')
    println('3: Lend a book')
    println('4: Return a book')
    println('5: Display loan stock')
    println('6: Display number of books on loan to a borrower')
    println('7: Display number of borrowers of a book')
       
    print('\n\tEnter choice: ')      
    return Console.readLine()
} 

def library = ['Groovy' : ['Ken', 'John'],
               'OOD' : ['Ken'],
               'Java' : ['John', 'Sally'],
               'UML' : ['Sally'],
               'Basic' : []
              ]

def doAddBook = { 
    def addBook = {bookTitle -> library[bookTitle]= []}
    addBook.call(readBookTitle()) 	// explicit call
}

def doRemoveBook = {
    def removeBook = {bookTitle -> library.remove(bookTitle)}
    removeBook(readBookTitle())	// implicit call
}

def doLendBook = {
    def lendBook = {bookTitle, borrowerName -> library[bookTitle] << borrowerName}
    lendBook(readBookTitle(), readBorrowerName()) 
}

def doReturnBook = {
    def returnBook = {bookTitle, borrowerName -> library[bookTitle].remove(borrowerName)}
    returnBook(readBookTitle(), readBorrowerName())
}

def doDisplayLoanStock = {
    def writeLoanStock = {println "\nLibrary stock: ${library} \n"}  
    writeLoanStock(library) 
}

def doDisplayNumberBooksOnLoanToBorrower = {
    def readNumberBorrowedBooks = {
        borrowerName ->
            def borrowerNames = new ArrayList(library.values())
            borrowerNames = borrowerNames.flatten()
            return borrowerNames.count(borrowerName)
    }

    def count = readNumberBorrowedBooks(readBorrowerName())
    println "\nNumber of books borrowed: ${count}\n"
}

def doDisplayNumberBorrowersOfBook = {
    def readNumberBorrowers = {bookTitle -> return library[bookTitle].size()}
    def count = readNumberBorrowers(readBookTitle())
    println "\nNumber of borrowers: ${count}\n"  
}

def menu = [ '1' : doAddBook, '2' : doRemoveBook,
             '3' : doLendBook,'4' : doReturnBook,
             '5' : doDisplayLoanStock, '6' : doDisplayNumberBooksOnLoanToBorrower,
             '7' : doDisplayNumberBorrowersOfBook
             
           ]
   
def choice = readMenuSelection()
while(choice != '0'){
    menu[choice].call()  
    choice = readMenuSelection()
}

println('\nSystem closing\n')