/**
 *  A library comprises a stock of books. Associated with each book
 *  title there is a list of the names of each borrower. If the list
 *  is empty then the book is not on loan to any borrower.
 *  
 *  The system should be able to:
 *
 *	add and remove books from the loan stock;
 *	record the loan and return of a book;
 *	display details of the current loan stock;
 *	display the number of books on loan to a given borrower and
 *	display the number of borrowers of a book. 
 *
 */

def addBook(library, bookTitle) {
    library[bookTitle]= []
}

def removeBook(library, bookTitle) {
    library.remove(bookTitle)
}

def lendBook(library, bookTitle, borrowerName) {
    library[bookTitle] << borrowerName
}

def returnBook(library, bookTitle, borrowerName) {
    library[bookTitle].remove(borrowerName)
}

def displayLoanStock(library) {
    println "Library stock: ${library} \n"
}

def readNumberBorrowedBooks(library, borrowerName) {
    def borrowerNames = library.values().asList()
    borrowerNames = borrowerNames.flatten()
    return borrowerNames.count(borrowerName)
}

def readNumberBorrowers(library, bookTitle) {
    return library[bookTitle].size()
}

// Initialize the loan stock
def library = ['Groovy' : ['Ken', 'John'],'OOD' : ['Ken'], 'Java' : ['John', 'Sally'],
               'UML' : ['Sally'],
               'Basic' : []]
              
    // Test Case:  Display loan stock
println 'Test Case: Display loan stock'
displayLoanStock(library)

    // Test Case: Add a new book
println 'Test Case: Add a new book'
addBook(library, 'C#')
displayLoanStock(library)

    // Test Case: Remove a book
println 'Test Case: Remove a book'
removeBook(library, 'UML')
displayLoanStock(library)

    // Test Case: Record a book loan to a borrower
lendBook(library, 'Java', 'Ken')
println 'Test Case: Record a book loan to a borrower'
displayLoanStock(library)

    // Test Case: Record a book return by a borrower
returnBook(library, 'Java', 'Sally')
println 'Test Case: Record a book return by a borrower'
displayLoanStock(library)

    // Test Case:  Display the number of books on loan to a borrower
println 'Test Case: Display the number of books on loan to a borrower'
println "Number of books on loan to Ken: ${readNumberBorrowedBooks(library, 'Ken')} \n"

    // Test Case: Display the number of borrowers of a book
println 'Test Case: Display the number of borrowers of a book'
println "Number of borrowers of Java: ${readNumberBorrowers(library, 'Java')} \n"	 