/**
 *  A bank account represented by two properties for the account
 *    number and the account balance. The class includes a toString
 *    method and we create a list of Account objects.
 */

class Account {
    def number			// account number
    def balance			// current balance
    
    def credit(amount) {
        balance += amount
    }
    
    def debit(amount) {		// only if there are sufficient funds
        if(balance >= amount)
            balance -= amount
    }
    
    def toString() {		// see also next example
        return "Account: ${number} with balance: ${balance}"
    }
    
}

	//  create some instances
def acc1 = new Account(number : 'ABC123', balance : 1200)
def acc2 = new Account(number : 'PQR456', balance : 200)
def acc3 = new Account(number : 'XYZ789', balance : 123)

	//  populate a list with the instances
def accounts = [acc1, acc2, acc3]

	//  now display each
accounts.each { acc ->
    println acc.toString()
}
