/**
 *  A Library populated with Book objects. We can add a new Book
 *    to the Library, and we can obtain a listing of the stock.
 *    Additionally, we can register new borrowers and lend/return
 *    books to/from borrowers. The application is supported by a
 *    simple text menu.
 */

import console.*

class Book {
    
    def attachBorrower(borrower) {
        this.borrower = borrower
    }
    
    def detachBorrower() {
        borrower = null
    }
    
    String toString() {		// redefinition
        return "Book: ${catalogNumber}: ${title} by: ${author}"
    }
    
// ---------- properties ----------------------------------

    def catalogNumber
    def title
    def author
    def borrower = null
    
}


class Borrower {
    
    def attachBook(bk) {
        borrowedBooks[bk.catalogNumber] = bk
        bk.attachBorrower(this)
    }
    
    def detachBook(bk) {
        borrowedBooks.remove(bk.catalogNumber)
        bk.detachBorrower()
    }
    
    String toString() {
        return "Borrower: ${membershipNumber}; ${name}"
    }
    
// ---------- properties ----------------------------------

   def membershipNumber
   def name
   def borrowedBooks = [ : ]
}


class Library {
        
    def addBook(bk) {
        loanStock[bk.catalogNumber] = bk
    }

    def registerBorrower(borrower) {
        borrowers[borrower.membershipNumber] = borrower
    }

    def lendBook(catalogNumber, membershipNumber) {
        def loanStockEntry = loanStock.find { entry -> entry.key == catalogNumber }
        def borrowersEntry = borrowers.find { entry  -> entry.key == membershipNumber }
        borrowersEntry.value.attachBook(loanStockEntry.value)
    }
    
    def returnBook(catalogNumber) {
        def loanStockEntry = loanStock.find { entry -> entry.key == catalogNumber }
        def bor = loanStockEntry.value.borrower
        bor.detachBook(loanStockEntry.value)
    }

// ---------- properties ----------------------------------

   def name
   def loanStock = [ : ]
   def borrowers = [ : ]
}



class Action {

    def addBook() {
        print('\nEnter book catalog number: ')
        def catalogNumber = Console.readLine()
        print('Enter book title: ')
        def title = Console.readLine()
        print('Enter book author: ')
        def author = Console.readLine()
            
        def bk = new Book(catalogNumber : catalogNumber, title : title, author : author)
            
        library.addBook(bk)
    }
    
    def displayStock() {
        println "\n\nLibrary: ${library.name}"
        println '================'
        
        library.loanStock.each { catalogNumber, book -> println "    ${book}" }
    }
    
    def displayBooksAvailableForLoan() {
        println "\n\nLibrary: ${library.name} : Available for loan"
        println '================'
        
        library.loanStock.each { catalogNumber, book -> if(book.borrower == null) println "    ${book}" }
    }
    
    def displayBooksOnLoan() {
        println "\n\nLibrary: ${library.name} : On loan"
        println '================'
        
        library.loanStock.each { catalogNumber, book -> if(book.borrower != null) println "    ${book}" }
    }
    
    def registerBorrower() {
        print('\nEnter borrower membership number: ')
        def membershipNumber = Console.readLine()
        print('Enter borrower name: ')
        def name = Console.readLine()
        
        def bor = new Borrower(membershipNumber : membershipNumber, name : name)
        
        library.registerBorrower(bor)
    }
    
    def displayBorrowers() {
        println "\n\nLibrary: ${library.name} : Borrower details"
        println '================'
        
        library.borrowers.each { membershipNumber, borrower ->
            println borrower            
            borrower.borrowedBooks.each { catalogNumber, book -> println "    ${book}" }
        }
    }
    
    def lendBook() {
        print('\nEnter book catalog number: ')
        def catalogNumber = Console.readLine()
        print('Enter borrower membership number: ')
        def membershipNumber = Console.readLine()
        
        library.lendBook(catalogNumber, membershipNumber)
    }
    
    def returnBook() {
        print('\nEnter book catalog number: ')
        def catalogNumber = Console.readLine()
        
        library.returnBook(catalogNumber)
    }
    
// ---------- properties ----------------------------------

    def library
}


def readMenuSelection() {
    println()
    println('0: Quit')
    println('1: Add new book')
    println('2: Display stock')
    println('3: Display books available for loan')
    println('4: Display books on loan')
    println('5: Register new borrower')
    println('6: Display borrowers')
    println('7: Lend one book')
    println('8: Return one book')
    
    print('\n\tEnter choice>>> ')
    return Console.readString()
}


	//  make the Action object
def action = new Action(library : new Library(name : 'Dunning'))

	//  make first selection
def choice = readMenuSelection()
while(choice != '0') {

    if(choice == '1') {					// Add new book
        action.addBook()
    } else if(choice == '2') {				// Display stock
        action.displayStock()
    } else if(choice == '3') {				// Display books available for loan
        action.displayBooksAvailableForLoan()
    } else if(choice == '4') {				// Display books on loan
        action.displayBooksOnLoan()
    } else if(choice == '5') {				// Register new borrower
        action.registerBorrower()
    } else if(choice == '6') {				// Display borrowers
        action.displayBorrowers()
    } else if(choice == '7') {				// Lend one book
        action.lendBook()
    } else if(choice == '8') {				// Return one book
        action.returnBook()
    } else {
        println("Unknown selection")
    }
	//  next selection
    choice = readMenuSelection()
}
println('\nSystem closing')                                                                                                                                                                                                                                                                