/**
 *  An illustration of class specialization. Class CurrentAccount
 *    is defined as a specialization of the class Account. The abstract
 *    Account class also includes a deferred method 'display' that
 *    concrete subclasses must define.
 */

abstract class Account {

    String toString() {				// redefinition
        return "${number}; ${balance}"
    }
    
    def abstract isOverdrawn()			// deferred method
    
// ---------- properties ----------------------------------

    def number
    def balance
    
}

class CurrentAccount extends Account {

    String toString() {
        return 'Current Account: ' + super.toString() + "; ${overdraftLimit}"
    }
    
    def isOverdrawn() {				// redefinition
        return balance < -overdraftLimit
    }
    
// ---------- properties ----------------------------------

    def overdraftLimit
}

class DepositAccount extends Account {

    String toString() {
        return 'Deposit Account: ' + super.toString() + "; ${interestRate}"
    }
    
    def isOverdrawn() {				// redefinition
        return balance < 0
    }
    
// ---------- properties ----------------------------------

    def interestRate
}

class Bank {
    
    def openAccount(account) {
        accounts[account.number] = account
    }
    
// ---------- properties ----------------------------------

    def name
    def accounts = [ : ]
}
    
def displayBank(bk) {
    println "Bank: ${bk.name}"
    println '===================='
        
    bk.accounts.each { number, account -> println "  ${account}" }
}

	//  create a new Bank object
def bk = new Bank(name : 'Barclay')

	//  create some accounts
def ca1 = new CurrentAccount(number : 'AAA111', balance : 2000, overdraftLimit : 400)
def ca2 = new CurrentAccount(number : 'BBB222', balance : 3000, overdraftLimit : 800)
def da1 = new DepositAccount(number : 'CCC333', balance : 4000, interestRate : 4)

	//  add them to the bank
bk.openAccount(ca1)
bk.openAccount(ca2)
bk.openAccount(da1)

	//  now display everything
displayBank(bk)

	//  check status of some accounts
println "Current account: ${ca1.number}; overdrawn?: ${ca1.isOverdrawn()}"
println "Deposit account: ${da1.number}; overdrawn?: ${da1.isOverdrawn()}"
