import groovy.util.GroovyTestCase

class LibraryTest extends GroovyTestCase {

   /** 
    * Set up the fixture
    */
   void setUp(){
        lib = new Library(name : 'Dunning')
        
        bk1 = new Book(catalogNumber : '111', title : 'Groovy', author : 'Ken')
        bk2 = new Book(catalogNumber : '222', title : 'OOD', author : 'Ken')
        bk3 = new Book(catalogNumber : '222', title : 'UML', author : 'John')
        
        bor1 = new Borrower(membershipNumber : '1234', name : 'Jessie')
        bor2 = new Borrower(membershipNumber : '2345', name : 'Peter')
        bor3 = new Borrower(membershipNumber : '2345', name : 'Jane')
    }

    /**
     * Test that addition of a Book to an empty Library results in one more Book
     * in the Library
     */
    void testAddBook_1() {
        def pre = lib.loanStock.size()
        lib.addBook(bk1)
        def post = lib.loanStock.size()

        assertTrue('one less book than expected', post == pre + 1)    
    }

    /**
     * Test that the addition of two Books with different catalog numbers
     * to an empty Library results in two Books in the Library
     */
    void testAddBook_2() {        
        lib.addBook(bk1)
        lib.addBook(bk2)
        def expected = 2
        def actual = lib.loanStock.size()

        assertTrue('unexpected number of books', actual == expected)    
    } 

    /**
     * Test that addition of a Book with the same catalog number
     * as one already present in the Library results in no change
     * to the number of Books in the Library
     */
    void testAddBook_3() {        
        lib.addBook(bk1)
        lib.addBook(bk2)
        def pre = lib.loanStock.size()
        lib.addBook(bk3)
        def post = lib.loanStock.size()

        assertTrue('one more book than expected', post == pre)    
    } 

    /** 
     * Test that addition of a Book with the same catalog number
     * as one already present in the Library results in no change
     *  to the loan stock
     */
    void testAddBook_4() {        
        lib.addBook(bk2)
        lib.addBook(bk3)
        def expected = 'Book: 222: OOD by: Ken'
        def actual = lib.loanStock['222']

        assertToString(actual, expected)     
    } 

    /**
     * Test that successfully adding a Book to the Library
     * is detected
     */
    void testAddBook_5() {        
        def success = lib.addBook(bk2)

        assertTrue('addition expected', success)
    } 

    /** 
     * Test that unsuccessfully attempting to add a Book with the same
     * catalog number as one already present in the Library is detected
     */
    void testAddBook_6() {        
        lib.addBook(bk2)
        def success = lib.addBook(bk3)

        assertFalse('no addition expected', success)    
    } 

    /** Test that registering a Borrower with an empty Library results
     *  in one more Borrower in the Library
     */
    void testRegisterBorrower_1() {
        def pre = lib.borrowers.size()
        lib.registerBorrower(bor1)
        def post = lib.borrowers.size()

        assertTrue('one less borrower than expected', post == pre + 1)
    }
    
    // Exercise 15.5.1
    /** Test that registering two Borrowers with different membership numbers
     *  to an empty Library results in two Borrowers in the Library
     */
    void testRegisterBorrower_2() {
        lib.registerBorrower(bor1)
        lib.registerBorrower(bor2)
        def expected = 2
        def actual = lib.borrowers.size()

        assertTrue('unexpected number of borrowers', actual == expected)        
    }

    // Exercise 15.5.2
    /** Test that an attempt to register a Borrower with the same membership number
     * as one already in the Library results in no change to the number of Borrowers
     * in the Library
     */     
    void testRegisterBorrower_3() {
        lib.registerBorrower(bor2)
        def pre = lib.borrowers.size()
        lib.registerBorrower(bor3)
        def post = lib.borrowers.size()

        assertTrue('one more borrower than expected', post == pre)
    }

    // Exercise 15.5.3
    /** Test that an attempt to register a Borrower with the same membership number
     *  as one already in the Library results in no change to the borrowers already registered
     */
    void testRegisterBorrower_4() {
        lib.registerBorrower(bor2)
        lib.registerBorrower(bor3)
        def expected = 'Borrower: 2345; Peter'
        def actual = lib.borrowers['2345']

        assertToString(actual, expected)
    }

// ---------- properties ----------------------------------

    def lib
    
    def bk1
    def bk2
    def bk3
    
    def bor1
    def bor2
    def bor3
    	
}