class Library {
        
    def addPublication(pub) {
        loanStock[pub.getCatalogNumber()] = pub
    }

    def getPublication(catalogNumber) {
        return loanStock[catalogNumber]
    }             

    def registerBorrower(borrower) {
        borrowers[borrower.membershipNumber] = borrower
    }
    
    def lendPublication(catalogNumber, membershipNumber) {
        def pub = getPublication(catalogNumber)
        def bor = getBorrower(membershipNumber)
        bor.attachPublication(pub)
    }
    
    def returnPublication(catalogNumber) {
        def pub = getPublication(catalogNumber)
        def bor = pub.getBorrower()
        bor.detachPublication(pub)
    }   
    
// ---------- properties ----------------------------------

    @Property name
    @Property loanStock = [ : ]
    @Property borrowers = [ : ]
    
}