class Library {
        
    def addPublication(publication) {
        if(!loanStock.containsKey(publication.catalogNumber)){
            loanStock[publication.catalogNumber] = publication
            return true
        }
        else
            return false
    }

    def registerBorrower(borrower) {
        if(!borrowers.containsKey(borrower.membershipNumber)) {
            borrowers[borrower.membershipNumber] = borrower
            return true
        }
        else
            return false
    }

    def lendPublication(catalogNumber, membershipNumber) {
        def publication = loanStock.find { entry -> entry.key == catalogNumber }
        def borrower = borrowers.find { entry -> entry.key == membershipNumber }
        borrower.value.attachPublication(publication.value)
    }
    
    def returnPublication(catalogNumber) {
        def publication = loanStock.find { entry -> entry.key == catalogNumber }
        def borrower = publication.value.borrower
        borrower.detachPublication(publication.value)
    }

// ---------- properties ----------------------------------

    def name
    def loanStock = [ : ]
    def borrowers = [ : ]
}