/**
 *  A Library populated with publications that are either books or journals.
 *  We can add a new publications to the library, and we can obtain a listing of the stock.
 *  Additionally, we can register new borrowers and lend/return
 *  publications to/from borrowers. The application is supported by a
 *  simple text menu.
 */

import console.*

def readMenuSelection() {
    println()
    println('0: Quit')
    println('1: Add new book')
    println('2: Add new journal')
    println('3: Display stock')
    println('4: Display publications available for loan')
    println('5: Display publications on loan')
    println('6: Register new borrower')
    println('7: Display borrowers')
    println('8: Lend one publication')
    println('9: Return one publication')
    
    print('\n\tEnter choice>>> ')
    return Console.readString()
}


	//  make the Action object
def action = new Action(library : new Library(name : 'Dunning'))

	//  make first selection
def choice = readMenuSelection()
while(choice != '0') {

    if(choice == '1') {					// Add new book
        action.addBook()
    } else if(choice == '2') {				// Add new journal
        action.addJournal()
    } else if(choice == '3') {				// Display stock
        action.displayStock()
    } else if(choice == '4') {				// Display publications available for loan
        action.displayPublicationsAvailableForLoan()
    } else if(choice == '5') {				// Display publications on loan
        action.displayPublicationsOnLoan()
    } else if(choice == '6') {				// Register new borrower
        action.registerBorrower()
    } else if(choice == '7') {				// Display borrowers
        action.displayBorrowers()
    } else if(choice == '8') {				// Lend one publication
        action.lendPublication()
    } else if(choice == '9') {				// Return one publication
        action.returnPublication()
    } else {
        println("Unknown selection")
    }
	//  next selection
    choice = readMenuSelection()
}
println('\nSystem closing')