import groovy.util.GroovyTestCase



class LibraryTestCase extends GroovyTestCase {

   /** 
    * Set up the fixture
    */
   void setUp(){
        lib = new Library(name : 'Dunning')	
        bk1 = new Book(catalogNumber : 111, title : 'Groovy', author : 'K Barclay')
        bor1 = new Borrower(membershipNumber : 1234, name : 'P Thompson')
    }

    /**
     * Test that the Library has one more Publication
     */
    void testAddPublication() {
        def pre = lib.loanStock.size()
        lib.addPublication(bk1)
        def post = lib.loanStock.size()

        assertTrue('one less publication than expected', post == pre +1)    
    }
   

    /**
     * Test that the Library has one more a Borrower
     */
    void testRegisterBorrower() {
        def pre = lib.borrowers.size()
        lib.registerBorrower(bor1)
        def post = lib.borrowers.size()

        assertTrue('one less borrower than expected', post == pre + 1)
    }

    /**
     * Test that the Borrower has more Publication on loan
     */
    void testLendPublication() {
        lib.addPublication(bk1)
        lib.registerBorrower(bor1)
        def borrower = lib.borrowers[bor1.membershipNumber]
        def pre = borrower.borrowedPublications.size()
        
        lib.lendPublication(bk1.catalogNumber, bor1.membershipNumber)

        borrower = lib.borrowers[bor1.membershipNumber]
        def post = borrower.borrowedPublications.size()

        assertTrue('one less publication than expected', post == pre + 1)
        
    }

    /**
     * Test that the Borrower has one less Publication on loan
     */
    void testReturnPublication() {
        lib.addPublication(bk1)
        lib.registerBorrower(bor1)
        lib.lendPublication(bk1.catalogNumber, bor1.membershipNumber)
        def borrower = lib.borrowers[bor1.membershipNumber]
        def pre = borrower.borrowedPublications.size()

        lib.returnPublication(bk1.catalogNumber)

        borrower = lib.borrowers[bor1.membershipNumber]
        def post = borrower.borrowedPublications.size()

        assertTrue('one more publication than expected', post == pre - 1)
    }
   
// ---------- properties ----------------------------------

    def lib
    def bk1
    def bor1
	
}