/**
 *  A Library populated with publications that are either books or journals.
 *  TBD 
 *  The application is supported by a simple text menu.
 */

import console.*

def readMenuSelection() {
    println()
    println('0: Quit\n')
    println('1:  Add new book')
    println('2:  Add new journal')
    println('3:  Remove a publication\n')
    println('4:  Display stock')
    println('5:  Display selected publications')
    println('6:  Display one publication')
    println('7:  Display publications available for loan')
    println('8:  Display publications on loan\n')
    println('9:  Register new borrower')
    println('10: Display all borrowers')
    println('11: Display selected borrowers')
    println('12: Display one borrower\n')
    println('13: Lend one publication')
    println('14: Return one publication\n')
    
    print('\n\tEnter choice>>> ')
    return Console.readString()
}


	//  make the Action object
def action = new Action(library : new Library(name : 'Dunning'))

	//  make first selection
def choice = readMenuSelection()
while(choice != '0') {

    if(choice == '1') {					// Add new book
        action.addBook()
    } else if(choice == '2') {				// Add new journal
        action.addJournal()
    } else if(choice == '3') {				// remove a publication
        action.removePublication()
    }else if(choice == '4') {				// Display stock
        action.displayAllStock()
    } else if(choice == '5') {				// Display selected stock
        action.displaySelectedStock()
    } else if(choice == '6') {				// Display one publication
        action.displayOnePublication()
    } else if(choice == '7') {				// Display publications available for loan
        action.displayPublicationsAvailableForLoan()
    } else if(choice == '8') {				// Display publications on loan
        action.displayPublicationsOnLoan()
    } else if(choice == '9') {				// Register new borrower
        action.registerBorrower()
    } else if(choice == '10') {				// Display all borrowers
        action.displayAllBorrowers()
    } else if(choice == '11') {				// Display selected borrowers
        action.displaySelectedBorrowers()
    } else if(choice == '12') {				// Display one borrower
        action.displayOneBorrower()
    } else if(choice == '13') {				// Lend one publication
        action.lendPublication()
    } else if(choice == '14') {				// Return one publication
        action.returnPublication()
    } else {
        println("\nUnknown selection")
    }
	//  next selection
    choice = readMenuSelection()
}
println('\nSystem closing\n')