class Library {   
 
    def addPublication(publication) {
        def message
        if(loanStock.containsKey(publication.catalogNumber)== false){            
            loanStock[publication.catalogNumber] = publication
            message = 'Publication added'
        }
        else 
            message = 'Cannot add: publication already present'
            
        return message
    }

    def removePublication(catalogNumber) {
        def message       
        if(loanStock.containsKey(catalogNumber)== true){
            def publication = loanStock[catalogNumber]
            //
            //note: use of safe navigation             
            publication.borrower?.detachPublication(publication)
            publication.borrower = null            
            loanStock.remove(catalogNumber)            
            message = 'Publication removed'
        }
        else 
            message = 'Cannot remove: publication not present' 
        
        return message
    }
    
    def registerBorrower(borrower) {
        def message
        if(borrowers.containsKey(borrower.membershipNumber)== false){            
            borrowers[borrower.membershipNumber] = borrower
            return 'Borrower registered'
        }
        else 
            return 'Cannot register: borrower already registered'
        
        return message
    }
      
    def lendPublication(catalogNumber, membershipNumber) {
        def message
        if(loanStock.containsKey(catalogNumber)== true){
            def publication = loanStock[catalogNumber]
            if(publication.borrower == null){
                if(borrowers.containsKey(membershipNumber)== true){ 
                    def borrower = borrowers[membershipNumber]
                    if(borrower.borrowedPublications.size() < Borrower.LIMIT) {                         
                        borrower.attachPublication(publication)
                        this.checkPublicationBorrowerLoopInvariant('Library.lendPublication')
                        message = 'Publication loaned'
                    }
                    else 
                        message = 'Cannot lend: borrower over limit'                                       
                }
                else 
                    message = 'Cannot lend: borrower not registered'                
            }
            else 
                message = 'Cannot lend: publication already on loan'            
        }
        else 
            message = 'Cannot lend: publication not present'
            
        return message        
    }
  
    def returnPublication(catalogNumber) {
        def message
        if(loanStock.containsKey(catalogNumber)== true){
            def publication = loanStock[catalogNumber]
            if(publication.borrower != null){                
                publication.borrower.detachPublication(publication)
                message = 'Publication returned'
            }
            else 
                message = 'Cannot return: publication not on loan'            
        }
        else 
            message = 'Cannot return: publication not present'
            
        return message        
    }  

    private checkPublicationBorrowerLoopInvariant(methodName) {
        def publications = loanStock.values().asList()

        def onLoanPublications = publications.findAll{ publication -> publication.borrower != null }
     
        def allOK = onLoanPublications.every{ publication ->
             publication.borrower.borrowedPublications.containsKey(publication.catalogNumber)
        }  
        
        if( allOK == false ){
            throw new Exception("${methodName}: Invariant failed")
        }
    }  
   
// ---------- properties ----------------------------------

    def name
    def loanStock = [ : ]
    def borrowers = [ : ]
       
}