/**
 *  The DB includes a simple table entitled 'account'. This has
 *    two columns named number and balance. A row from this table
 *    represents a simple bank account.
 */

import groovy.sql.*

def DB = 'jdbc:derby:accountDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'

def displayAccounts(banner, sql) {
    println banner
    sql.eachRow('select * from accounts') { acc ->
        println "  Account: ${acc.number} ${acc.balance}"
    }
    println()
}

	//  Connect to database
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)

	//  Iterate over the result set
displayAccounts('Initial content', sql)

	//  Now insert a new row...
sql.execute("insert into accounts(number, balance) values('GHI789', 600)")

	//  ...and another
def newNumber = 'AAA111'
def newBalance = 1600
sql.execute("insert into accounts(number, balance) values(${newNumber}, ${newBalance})")

	//  Now see what we have
displayAccounts('After inserts', sql)

	//  Restore original
['GHI789', 'AAA111'].each { accNumber ->
    sql.execute('delete from accounts where number = ?', [accNumber])
}

	//  Now see that they have gone
displayAccounts('After deletes', sql)
