/**
 *  The DB includes a simple table entitled 'account'. This has
 *    two columns named number and balance. A row from this table
 *    represents a simple bank account.
 */

import groovy.sql.*

def DB = 'jdbc:derby:accountDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'

def displayAccounts(banner, dSet) {
    println banner
    dSet.each { acc ->
        println "  Account: ${acc.number} ${acc.balance}"
    }
    println()
}

	//  Connect to database
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)
def accounts = sql.dataSet('accounts')

	//  Iterate over the data set
displayAccounts('Initial content', accounts)

	//  Now insert a new row...
accounts.add(number : 'GHI789', balance : 600)

	//  ...and another
def newNumber = 'AAA111'
def newBalance = 1600
accounts.add(number : newNumber, balance : newBalance)

	//  Now see what we have
displayAccounts('After inserts', accounts)

	//  Restore original
['GHI789', 'AAA111'].each { accNumber ->
    accounts.execute('delete from accounts where number = ?', [accNumber])
}

	//  Now see that they have gone
displayAccounts('After deletes', accounts)
