/**
 *  The DB includes two tables entitled 'bank' and 'account'. The
 *    account has two columns named number and balance. The bank
 *    table has a single name column. Both tables have an auto-
 *    generated column 'id' which acts as the primary key. Finally,
 *    the account table has a foreign key entitled bankID into the
 *    bank table.
 */

import groovy.sql.*

def DB = 'jdbc:derby:bankDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'

def displayBanks(banner, dSet) {
    println banner
    dSet.each { bk ->
        println "  Bank: ${bk.id} ${bk.name}"
    }
    println()
}

def displayAccounts(banner, dSet) {
    println banner
    dSet.each { acc ->
        println "  Account: ${acc.id} ${acc.bankID} ${acc.number} ${acc.balance}"
    }
    println()
}

	//  Connect to database
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)
def banks = sql.dataSet('banks')
def accounts = sql.dataSet('accounts')

	//  Query the bank table
displayBanks('Banks', banks)

	//  Query the account table
displayAccounts('Accounts', accounts)



	//  Now add a new bank...
banks.add(id : 'CB', name : 'Clydebank')

	//  ...and check it is there
displayBanks('Banks (after add)', banks)

	//  Now add a new account to this new bank...
accounts.add(bankID : 'CB', number : 'AAA111', balance : 1600)

	//  ...and check it is there...
displayAccounts('Accounts (after add)', accounts)

	//  ...then remove it...
accounts.execute('delete from accounts where number = ?', ['AAA111'])

	//  ...and check it is gone
displayAccounts('Accounts (after delete)', accounts)

	//  Now remove the new bank...
banks.execute('delete from banks where id = ?', ['CB'])

	//  ...and check it is gone
displayBanks('Banks (after delete)', banks)
