/**
 *  The accountDB database contians a single table entitled
 *    accounts. This table has number and balance columns
 *    representing the values for an account.
 *
 *  The programs creates Account objects for every row in
 *    the accounts table.
 */

import groovy.sql.*

def DB = 'jdbc:derby:accountDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'


	//  Connect to database
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)

	//  Prepare the query object
def accQuery = new AccountQuery(sql)

	//  Get the Accounts
def accs = accQuery.execute()

accs.each { acc ->
    println "${acc}"
}
