/**
 *  Transform the orders, replacing the customer and product ids.
 */

import groovy.sql.*
import groovy.util.*
import groovy.xml.*

def DB = 'jdbc:derby:orderinfoDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'

	//  Connect to database
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)

def parser = new XmlParser()
def doc = parser.parse('orderinfo.xml')

	//  Create a builder
def mB = new MarkupBuilder(new File('orderinfo.details.xml').newPrintWriter())

mB.orderinfo() {
    doc.customer.each { cust ->
        mB.customer(group : cust['@group']) {
            def customer = sql.firstRow('select * from customers where id = ?', [cust.id[0].text()])
            mB.id(customer.name)
            mB.serviceorders() {
                cust.serviceorders.order.each { order ->
                    mB.order() {
                        def product = sql.firstRow('select * from products where id = ?', [order.productid[0].text()])
                        mB.productid(product.name)
                        mB.price(order.price[0].text())
                    }
                }
            }
        }
    }
}
