/**
 *  A simple Swing demonstration using a SwingBuilder.
 *    The example populates the frame with labels and
 *    text fields as might be used for data entry. The
 *    labels and fields are positioned with the use of
 *    a grid layout manager.
 *
 *  In this illustration, the builder is used to construct
 *    incrementally the various components.
 */

import groovy.swing.SwingBuilder
import javax.swing.*
import java.awt.*

	//  Create a builder
def sB = new SwingBuilder()

	//  Build the panel...
def mainPanel = {
    sB.panel(layout : new GridLayout(3, 2, 5, 5)) {
        label(text : 'Last name:', horizontalAlignment : JLabel.RIGHT)
        textField(text : '', columns : 10)
        label(text : 'Middle name:', horizontalAlignment : JLabel.RIGHT)
        textField(text : '', columns : 10)
        label(text : 'First name:', horizontalAlignment : JLabel.RIGHT)
        textField(text : '', columns : 10)
    }
}

	//  ...and the frame
def frame = sB.frame(title : 'Example03', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    mainPanel()
}

	//  Now show it
frame.pack()
frame.setVisible(true)
