/**
 *  A simple Swing demonstration using a SwingBuilder.
 *    The example populates the frame with buttons.
 *    The buttons have simple action handlers for when
 *    they are pressed.
 */

import groovy.swing.SwingBuilder
import javax.swing.*
import java.awt.*

	//  Handlers
def okHandler = { 
    println 'OK pressed'
}

def cancelHandler = {
    println 'Cancel pressed'
}

	//  Buttons
def buttons = [['OK', okHandler], ['Cancel', cancelHandler]]

	//  Create a builder
def sB = new SwingBuilder()

	//  Build the button panel...
def buttonPanel = {
    sB.panel(constraints : BorderLayout.SOUTH) {
        buttons.each { but ->
            sB.button(text : but[0], actionPerformed : but[1])
        }
    }
}

	//  ...then the main panel...
def mainPanel = {
    sB.panel(layout : new BorderLayout()) {
        label(text : 'Is this OK?', horizontalAlignment : JLabel.CENTER, constraints : BorderLayout.CENTER)
        buttonPanel()
    }
}

	//  ...and the frame
def frame = sB.frame(title : 'Example06', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    mainPanel()
}

	//  Now show it
frame.pack()
frame.setVisible(true)
