/**
 *  A simple GUI demonstrating the use of a box layout to construct
 *    a stack of buttons. Adjacent to the buttons is a text area which
 *    might be used to deliver output to the user.
 */

import groovy.swing.SwingBuilder
import javax.swing.*
import java.awt.*

	//  Button of set size
class FixedButton extends JButton {

    Dimension getMinimumSize() { return BUTTONSIZE }
    Dimension getMaximumSize() { return BUTTONSIZE }
    Dimension getPreferredSize() { return BUTTONSIZE }

    private static final BUTTONSIZE = new Dimension(80, 30)
}

	//  Text area of set size
class FixedTextArea extends JTextArea {

    Dimension getMinimumSize() { return TEXTAREASIZE }
    Dimension getMaximumSize() { return TEXTAREASIZE }
    Dimension getPreferredSize() { return TEXTAREASIZE }

    private static final TEXTAREASIZE = new Dimension(400, 400)
}


	//  Create a builder
def sB = new SwingBuilder()


	//  Now the main panel...
def mainPanel = {
    sB.panel(layout : new BorderLayout()) {
        vbox(constraints : BorderLayout.WEST) {
            def buttons = ['One', 'Two', 'Three', 'Four']
            buttons.each { but ->
                sB.widget(new FixedButton(text : but))
            }
        }
        panel(constraints : BorderLayout.CENTER) {
            widget(new FixedTextArea(enabled : false))
        }
    }
}

	//  ...and finally the frame
def frame = sB.frame(title : 'Example10', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    mainPanel()
}

	//  Now show it
frame.pack()
frame.setVisible(true)
