/**
 *  A template example to convert a Book template, replacing
 *    placemarkers for the author, etc. The result is saved to
 *    a file.
 */

import groovy.text.*
import java.io.*

def file = new File('book.template')
def binding = ['author'		: 'Ken Barclay',
               'title'		: 'Groovy',
               'publisher'	: 'Elsevier',
               'isbn'		: '1234567890'
              ]
def writable = new SimpleTemplateEngine().createTemplate(file).make(binding)
def destination = new FileWriter('book.xml')
writable.writeTo(destination)
destination.flush()
destination.close()
