/**
 *  A Library populated with Book and Journal objects. We can add new
 *    Book and Journals to the Library, and we can obtain a listing
 *    of the stock. Borrowers are registered with the library and can
 *    borrow and return publications.
 */

import groovy.swing.*
import groovy.sql.*
import javax.swing.*
import java.awt.*

/*****
class FixedButton extends JButton {

    Dimension getMaximumSize() { return BUTTONSIZE }
    Dimension getMinimumSize() { return BUTTONSIZE }
    Dimension getPreferredSize() { return BUTTONSIZE }
    
    private static final BUTTONSIZE = new Dimension(250, 30)
}

class FixedTextArea extends JTextArea {

    Dimension getMaximumSize() { return TEXTAREASIZE }
    Dimension getMinimumSize() { return TEXTAREASIZE }
    Dimension getPreferredSize() { return TEXTAREASIZE }
    
    private static final TEXTAREASIZE = new Dimension(600, 400)
}
*****/

	//  Event handlers
def doExit = {
    System.exit(0)
}

	//  Create the builder
def sB = new SwingBuilder()

	//  Create the button panel
def buttonPanel = {
    sB.panel(constraints : BorderLayout.WEST) {
        vbox() {
            widget(new FixedButton(text : "Exit"), actionPerformed : doExit )
            widget(new FixedButton(text : "Add new publication"))
            widget(new FixedButton(text : "Display stock"))
            widget(new FixedButton(text : "Display publications available for loan"))
            widget(new FixedButton(text : "Display publications on loan"))
            widget(new FixedButton(text : "Register new borrower"))
            widget(new FixedButton(text : "Display borrowers"))
            widget(new FixedButton(text : "Lend one publication"))
            widget(new FixedButton(text : "Return one publication"))
        }
    }
}

	//  Create display panel
def displayPanel = {
    sB.panel(constraints : BorderLayout.CENTER) {
        widget(new FixedTextArea(enabled : false))
    }
}

	//  Create status panel
def statusPanel = {
    sB.panel(constraints : BorderLayout.SOUTH) {
        label(text : "Status")
        textField(text : "", columns : 60, enabled : false)
    }
}

	//  Assemble main panel
def mainPanel = {
    sB.panel(layout : new BorderLayout()) {
        sB.panel(layout : new BorderLayout(), constraints : BorderLayout.CENTER) {
            buttonPanel()
            displayPanel()
        }
        statusPanel()
    }
}

	//  Main frame
def frame = sB.frame(title : "Library application", location : [50, 50], size : [800, 500], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    mainPanel()
}

frame.pack()
frame.setVisible(true)
