class Library {
    
    def Library(name, dao) {
    	this.name = name
        this.dao = dao
        
        def bors = dao.getBorrowers()
        bors.each { bor ->
            borrowers[bor.membershipNumber] = bor
        }

        def pubs = dao.getPublications(borrowers)
        pubs.each { pub ->
            loanStock[pub.catalogNumber] = pub
        }
        
    }
    
    def registerBorrower(borrower) {
        if(borrowers.containsKey(borrower.membershipNumber)== false) {
            dao.registerBorrower(borrower)
            borrowers[borrower.membershipNumber] = borrower
        }
    }
    
    def addPublication(publication) {
        dao.addPublication(publication)
        loanStock[publication.catalogNumber] = publication
    }
    
    def lendPublication(catalogNumber, membershipNumber) {
        if(loanStock.containsKey(catalogNumber) == true) {
            def publication = loanStock[catalogNumber]
            if(publication.borrower == null) {
                if(borrowers.containsKey(membershipNumber) == true) {
                    def borrower = borrowers[membershipNumber]
                    borrower.attachPublication(publication)
                    dao.lendPublication(catalogNumber, membershipNumber)
                }
            }
        }
    }
    
    def returnPublication(catalogNumber) {
        if(loanStock.containsKey(catalogNumber) == true) {
            def publication = loanStock[catalogNumber]
            if(publication.borrower != null) {
                def borrower = publication.borrower
                borrower.detachPublication(publication)
                dao.returnPublication(catalogNumber)
            }
        }
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property loanStock	= [ : ]
    @Property borrowers	= [ : ]

    @Property dao
    
}