import org.springframework.jdbc.object.*
import org.springframework.jdbc.core.*

class LibraryDaoJdbc implements LibraryDaoIF {
    
    def getBorrowers() {
        def bQuery = new BorrowerQuery(dataSource)
        return bQuery.execute()
    }

    def getPublications(borrowers) {
        def pQuery = new PublicationQuery(dataSource, borrowers)
        return pQuery.execute()
    }
    
    def addPublication(publication) {
        def params = null
        if(publication instanceof Book)
            params = [publication.catalogNumber, publication.title, publication.author, '', 'BOOK', null]
        else
            params = [publication.catalogNumber, publication.title, '', publication.editor, 'JOURNAL', null]
            
        def pInsert = new PublicationInsert(dataSource)
        pInsert.update(params as Object[])
    }
    
    def registerBorrower(borrower) {
        def params = [borrower.membershipNumber, borrower.name]
        
        def bInsert = new BorrowerInsert(dataSource)
        bInsert.update(params as Object[])
    }
    
    def lendPublication(catalogNumber, membershipNumber) {
        def params = [membershipNumber, catalogNumber]
        
        def pUpdate = new PublicationUpdate(dataSource)
        pUpdate.update(params as Object[])
    }
    
    def returnPublication(catalogNumber) {
        def params = [null, catalogNumber]
        
        def pUpdate = new PublicationUpdate(dataSource)
        pUpdate.update(params as Object[])
    }

// ---------- properties ----------------------------------

    @Property dataSource
}
