/**
 *  Groups all members into groups determined by the supplied mapping closure.
 */

def numbers = [11, 12, 12, 14, 12]

def groupByEvenOdd = numbers.groupBy { elem -> return (elem % 2 == 0) }
println "Dozen: ${groupByEvenOdd}"



class Person {
    
    public String toString() {
        return "${name} ${age}"
    }
    
    def name
    def age
}

def members = [new Person(name : 'Ken', age : 25),
               new Person(name : 'John', age : 29),
               new Person(name : 'Jon', age : 30),
               new Person(name : 'Ken', age : 21),
              ]
def groupByAges = members.groupBy { per -> return (per.age.intdiv(5) * 5) }
println "${groupByAges}"
