/**
 *  A Map with duplicate values for some of its keys. A simple solution is
 *    to associate each key of the Map with a List of its values.
 */

class MultiMapCategory {

    static void insert(Map map, Object key, Object value) {
        if(map.containsKey(key))
            map.put(key, map[key] << value)
        else
            map.put(key, [value])
    }
}

use(MultiMapCategory.class) {
    def data = [[1, 'a'], [1, 'b'], [1, 'c'],
                [2, 'a'], [2, ['b', 'c']],
                [3, 'c']
               ]
    def multiMap = [:]
    data.each { inner -> multiMap.insert(inner[0], inner[1]) }
    println "multiMap: ${multiMap}"
}
