/**
 *  A class to mimic a date range over which we can iterate with an each
 *    iterator.
 */

import java.text.*
import java.util.*

class CalendarRange {

    def each(Closure clos) {
        def date = startDate.clone()
        clos.call(date)
        while(date.equals(endDate) == false) {
            date.roll(Calendar.DAY_OF_YEAR, true)
            clos.call(date)
        }
    }
    
// ---------- properties --------------------------------

    def startDate
    def endDate
}

def formatter = new SimpleDateFormat("EEE MMM dd, yyyy")
def calRange = new CalendarRange(startDate : new GregorianCalendar(2006, 10, 24), endDate : new GregorianCalendar(2006, 10, 30))
calRange.each { gCal ->
    println "Date: ${formatter.format(gCal.getTime())}"
}
