/**
 *  A class to mimic a date range over which we can iterate with an each
 *    iterator. Ranges can be used for any Java object which implements
 *    java.lang.Comparable for comparison, and also have methods next()
 *    and previous() to return the next / previous item in the range.
 */

import java.text.*
import java.util.*

class CalendarRange extends GregorianCalendar {

    def CalendarRange(year, month, day) {
        super(year, month, day)
    }
    
    def next() {
        this.roll(Calendar.DAY_OF_YEAR, true)
        return this
    }
    
    def previous() {
        this.roll(Calendar.DAY_OF_YEAR, false)
        return this
    }
}

def formatter = new SimpleDateFormat("EEE MMM dd, yyyy")

def start = new CalendarRange(2006, 10, 24)
def end = new CalendarRange(2006, 10, 30)
def calRange = start..end
calRange.each { gCal ->
    println "Date: ${formatter.format(gCal.getTime())}"
}
