package extras

/**
 *  Zip together two lists to produce a single list. The result list
 *    comprises sub-lists of length two with corresponding elements
 *    taken from the input lists. Hence, the effect on the lists
 *    [x1, x2, ... ] and [y1, y2, ... ] is the resulting list
 *    [[x1, y1], [x2, y2], ... ].
 */

def zip = { list1, list2 ->
    def res = []
    def size = (list1.size() < list2.size()) ? list1.size() : list2.size()
    for(k in 0..<size) {
        res << [list1[k], list2[k]]
    }
    return res
}

def odds = [1, 3, 5, 7]
def evens = [2, 4, 6, 8]

println "zip: ${zip(odds, evens)}"
println "zip: ${zip([], evens)}"

